using System;
using Server.Engines.Craft;

namespace Server.Items
{
    public abstract class BaseSilkHat : BaseClothing
	{
		public BaseSilkHat( int itemID ) : this( itemID, 0 )
		{
		}

		public BaseSilkHat( int itemID, int hue ) : base( itemID, Layer.Helm, hue )
		{
		}

        public BaseSilkHat(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override int OnCraft( int quality, bool makersMark, Mobile from, CraftSystem craftSystem, Type typeRes, BaseTool tool, CraftItem craftItem, int resHue )
		{
			Quality = (ClothingQuality)quality;

			if( Quality == ClothingQuality.Exceptional )
				DistributeBonuses( (tool is BaseRunicTool ? 6 : (Core.SE ? 15 : 14)) );	//BLAME OSI. (We can't confirm it's an OSI bug yet.)

			return base.OnCraft( quality, makersMark, from, craftSystem, typeRes, tool, craftItem, resHue );
		}

	}
	[Flipable( 0x2798, 0x27E3 )]
    public class SilkKasa : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkKasa() : this( 0 )
		{
		}

		[Constructable]
		public SilkKasa( int hue ) : base( 0x2798, hue )
		{
			Weight = 3.0;
            Name = "Silk Kasa";
		}

        public SilkKasa(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x278F, 0x27DA )]
    public class SilkNinjaHood : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkNinjaHood() : this( 0 )
		{
		}

		[Constructable]
		public SilkNinjaHood( int hue ) : base( 0x278F, hue )
		{
			Weight = 2.0;
            Name = "Silk Ninja Hood";
		}

        public SilkNinjaHood(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x2306, 0x2305 )]
    public class SilkFlowerGarland : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkFlowerGarland() : this( 0 )
		{
		}

		[Constructable]
		public SilkFlowerGarland( int hue ) : base( 0x2306, hue )
		{
			Weight = 1.0;
            Name = "Silk Flower Garland";
		}

        public SilkFlowerGarland(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkFloppyHat : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkFloppyHat() : this( 0 )
		{
		}

		[Constructable]
		public SilkFloppyHat( int hue ) : base( 0x1713, hue )
		{
			Weight = 1.0;
            Name = "Silk Floppy Hat";
		}

        public SilkFloppyHat(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkWideBrimHat : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkWideBrimHat() : this( 0 )
		{
		}

		[Constructable]
		public SilkWideBrimHat( int hue ) : base( 0x1714, hue )
		{
			Weight = 1.0;
            Name = "Silk Wide-Brim Hat";
		}

        public SilkWideBrimHat(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkCap : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkCap() : this( 0 )
		{
		}

		[Constructable]
		public SilkCap( int hue ) : base( 0x1715, hue )
		{
			Weight = 1.0;
            Name = "Silk Cap";
		}

        public SilkCap(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkSkullCap : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkSkullCap() : this( 0 )
		{
		}

		[Constructable]
		public SilkSkullCap( int hue ) : base( 0x1544, hue )
		{
			Weight = 1.0;
            Name = "Silk Skull Cap";
		}

        public SilkSkullCap(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkBandana : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkBandana() : this( 0 )
		{
		}

		[Constructable]
		public SilkBandana( int hue ) : base( 0x1540, hue )
		{
			Weight = 1.0;
            Name = "Silk Bandana";
		}

        public SilkBandana(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkWizardsHat : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkWizardsHat() : this( 0 )
		{
		}

		[Constructable]
		public SilkWizardsHat( int hue ) : base( 0x1718, hue )
		{
			Weight = 1.0;
            Name = "Silk Wizard's Hat";
		}

        public SilkWizardsHat(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkBonnet : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkBonnet() : this( 0 )
		{
		}

		[Constructable]
		public SilkBonnet( int hue ) : base( 0x1719, hue )
		{
			Weight = 1.0;
            Name = "Silk Bonnet";
		}

        public SilkBonnet(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkFeatheredHat : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkFeatheredHat() : this( 0 )
		{
		}

		[Constructable]
		public SilkFeatheredHat( int hue ) : base( 0x171A, hue )
		{
			Weight = 1.0;
            Name = "Silk Feathered Hat";
		}

        public SilkFeatheredHat(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkTricorneHat : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkTricorneHat() : this( 0 )
		{
		}

		[Constructable]
		public SilkTricorneHat( int hue ) : base( 0x171B, hue )
		{
			Weight = 1.0;
            Name = "Silk Tricorne Hat";
		}

        public SilkTricorneHat(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

    public class SilkJesterHat : BaseSilkHat
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 6; } }
        public override int BaseColdResistance { get { return 11; } }
        public override int BasePoisonResistance { get { return 9; } }
        public override int BaseEnergyResistance { get { return 8; } }

        public override int InitMinHits { get { return 20; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkJesterHat() : this( 0 )
		{
		}

		[Constructable]
		public SilkJesterHat( int hue ) : base( 0x171C, hue )
		{
			Weight = 1.0;
            Name = "Silk Jester Hat";
		}

        public SilkJesterHat(Serial serial): base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}